/*
 * Decompiled with CFR 0.152.
 */
package cds.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class TextualSearchList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    public final KeyExtractor<E> keyExtractor;
    protected final HashMap<String, ArrayList<E>> csMap;
    protected final HashMap<String, ArrayList<E>> ncsMap;

    public TextualSearchList() {
        this(new DefaultKeyExtractor());
    }

    public TextualSearchList(KeyExtractor<E> keyExtractor) {
        this.keyExtractor = keyExtractor;
        this.csMap = new HashMap();
        this.ncsMap = new HashMap();
    }

    public TextualSearchList(int n) {
        this(n, new DefaultKeyExtractor());
    }

    public TextualSearchList(int n, KeyExtractor<E> keyExtractor) {
        super(n);
        this.keyExtractor = keyExtractor;
        this.csMap = new HashMap(n);
        this.ncsMap = new HashMap(n);
    }

    public TextualSearchList(Collection<? extends E> collection) {
        this(collection, new DefaultKeyExtractor());
    }

    public TextualSearchList(Collection<? extends E> collection, KeyExtractor<E> keyExtractor) {
        this.keyExtractor = keyExtractor;
        this.csMap = new HashMap(collection.size());
        this.ncsMap = new HashMap(collection.size());
        this.addAll(collection);
    }

    @Override
    public boolean contains(Object object) {
        try {
            if (object == null) {
                return false;
            }
            Object object2 = object;
            return !this.get(this.getKey(object2)).isEmpty();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final ArrayList<E> get(String string) {
        return this.get(string, false);
    }

    public ArrayList<E> get(String string, boolean bl) {
        ArrayList<E> arrayList;
        if (string == null) {
            return new ArrayList(0);
        }
        ArrayList<E> arrayList2 = arrayList = bl ? this.csMap.get(string) : this.ncsMap.get(string.toLowerCase());
        if (arrayList == null) {
            return new ArrayList(0);
        }
        return (ArrayList)arrayList.clone();
    }

    private final String getKey(E e) throws NullPointerException, IllegalArgumentException {
        String string = this.keyExtractor.getKey(e);
        if (string == null) {
            throw new NullPointerException("Null keys are not allowed in a TextualSearchList !");
        }
        return string;
    }

    private final void putIntoMaps(String string, E e) {
        TextualSearchList.putIntoMap(this.csMap, string, e);
        TextualSearchList.putIntoMap(this.ncsMap, string.toLowerCase(), e);
    }

    private static final <E> void putIntoMap(HashMap<String, ArrayList<E>> hashMap, String string, E e) {
        ArrayList<E> arrayList = hashMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(e);
            hashMap.put(string, arrayList);
        } else {
            arrayList.add(e);
        }
    }

    @Override
    public boolean add(E e) throws NullPointerException, IllegalArgumentException {
        if (e == null) {
            throw new NullPointerException("Null objects are not allowed in a TextualSearchList !");
        }
        String string = this.getKey(e);
        if (string == null) {
            return false;
        }
        if (super.add(e)) {
            this.putIntoMaps(string, e);
            return true;
        }
        return false;
    }

    @Override
    public void add(int n, E e) throws NullPointerException, IllegalArgumentException, IndexOutOfBoundsException {
        if (e == null) {
            throw new NullPointerException("Null objects are not allowed in a TextualSearchList !");
        }
        String string = this.getKey(e);
        if (string == null) {
            return;
        }
        super.add(n, e);
        if (this.get(n).equals(e)) {
            this.putIntoMaps(string, e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) throws NullPointerException, IllegalArgumentException {
        if (collection == null) {
            return false;
        }
        boolean bl = false;
        for (E e : collection) {
            bl = this.add(e) || bl;
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) throws NullPointerException, IllegalArgumentException, IndexOutOfBoundsException {
        if (collection == null) {
            return false;
        }
        boolean bl = false;
        int n2 = n;
        for (E e : collection) {
            this.add(n2++, e);
            bl = this.get(n2).equals(e);
        }
        return bl;
    }

    @Override
    public E set(int n, E e) throws NullPointerException, IllegalArgumentException {
        if (e == null) {
            throw new NullPointerException("Null objects are not allowed in a TextualSearchList !");
        }
        if (this.get(n).equals(e)) {
            return e;
        }
        String string = this.getKey(e);
        E e2 = super.set(n, e);
        String string2 = this.keyExtractor.getKey(e2);
        this.removeFromMaps(string2, e2);
        this.putIntoMaps(string, e);
        return e2;
    }

    @Override
    public void clear() {
        super.clear();
        this.csMap.clear();
        this.ncsMap.clear();
    }

    private final void removeFromMaps(String string, E e) {
        TextualSearchList.removeFromMap(this.csMap, string, e);
        TextualSearchList.removeFromMap(this.ncsMap, string.toLowerCase(), e);
    }

    private static final <E> void removeFromMap(HashMap<String, ArrayList<E>> hashMap, String string, E e) {
        ArrayList<E> arrayList = hashMap.get(string);
        if (arrayList != null) {
            arrayList.remove(e);
            if (arrayList.isEmpty()) {
                hashMap.remove(string);
            }
        }
    }

    @Override
    public E remove(int n) {
        Object e = super.remove(n);
        if (e != null) {
            String string = this.keyExtractor.getKey(e);
            this.removeFromMaps(string, e);
        }
        return e;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        if (bl) {
            String string = this.keyExtractor.getKey(object);
            this.removeFromMaps(string, object);
        }
        return bl;
    }

    @Override
    protected void removeRange(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.size() || n2 < 0 || n2 >= this.size() || n > n2) {
            throw new IndexOutOfBoundsException("Incorrect range indexes: from " + n + " to " + n2 + " !");
        }
        for (int i = n; i < n2; ++i) {
            this.remove(i);
        }
    }

    protected static class DefaultKeyExtractor<E>
    implements KeyExtractor<E> {
        protected DefaultKeyExtractor() {
        }

        @Override
        public String getKey(E e) {
            return e.toString();
        }
    }

    public static interface KeyExtractor<E> {
        public String getKey(E var1);
    }
}

